
function load {
	gamerule sendCommandFeedback false
	setblock -28 -56 197 air
	setblock -28 -60 197 air
	setblock -20 -56 197 air
	setblock -20 -60 197 air
	scoreboard objectives add LANG_MC_INTERNAL dummy
    # say Loaded office logic

    kill @e[type=item_display, tag=button_plate]
    kill @e[type=item_display, tag=button]

	team add door_button
	team modify door_button color red

	team add light_button
	team modify light_button color dark_gray

    # Button plate right window
    summon item_display -25.5 -58.5 193.5 {Tags:["button_plate", "right"], Rotation:[90.0f, 0.0f], item: {id: "minecraft:fire_charge", Count:1b, tag:{CustomModelData:1019}}}
    # Door button unpressed right window
    summon item_display -25.5 -58.5 193.5 {Tags:["button", "door_button", "right"], Rotation:[90.0f, 0.0f], item: {id: "minecraft:fire_charge", Count:1b, tag:{CustomModelData:1105}}}
	
    # Light button unpressed right window
    summon item_display -25.5 -58.5 193.5 {Tags:["button", "light_button", "right"], Rotation:[90.0f, 0.0f], item: {id: "minecraft:fire_charge", Count:1b, tag:{CustomModelData:1106}}}

    #Button plate left window
    summon item_display -21.5 -58.5 193.5 {Tags:["button_plate", "left"], Rotation:[-90.0f, 0.0f], item: {id: "minecraft:fire_charge", Count:1b, tag:{CustomModelData:1019}}}
    # Door button unpressed right window
    summon item_display -21.5 -58.5 193.5 {Tags:["button", "door_button", "left"], Rotation:[-90.0f, 0.0f], item: {id: "minecraft:fire_charge", Count:1b, tag:{CustomModelData:1105}}}
    # Light button unpressed right window
    summon item_display -21.5 -58.5 193.5 {Tags:["button", "light_button", "left"], Rotation:[-90.0f, 0.0f], item: {id: "minecraft:fire_charge", Count:1b, tag:{CustomModelData:1106}}}

	team join door_button @e[tag=door_button]
	team join light_button @e[tag=light_button]

    scoreboard objectives add ak.click minecraft.used:minecraft.carrot_on_a_stick
    scoreboard objectives add ak.state dummy

    scoreboard objectives add ak.const dummy
    scoreboard players set camera_multiplier ak.const 10

    scoreboard players set angle_biome_state ak.state 0
    scoreboard players set camera_angle ak.state -1

	kill @e[tag=office,tag=!chica.move,tag=!bonnie.move,tag=!freddy.move,tag=!foxy.move]
	kill @e[tag=office_door]

    # Office entities
    summon marker 23.5 -59.5 193.3 {Tags:["office","office_camera"]}
    summon item_display -23.5 <%-59.15+0.25%> 193.3 {item:{id:"minecraft:carrot_on_a_stick", Count:1b}, Tags:["office","office_mount"]}
    summon minecraft:interaction -23.5 -58.5 193.3 {width: 1, height: 1, Tags:["office","office_interact"]}


	summon item_display -20.5 -58.5 195.0 {item:{id:"minecraft:fire_charge", Count:1b, tag:{CustomModelData:1118}}, Tags:["office","office_door","left_door"]}
	summon armor_stand -20.5 -58.5 195.0 {Marker:1b, Invisible:1b, Tags:["office", "left_door", "mount"]}
	ride @e[type=item_display,tag=left_door,limit=1] mount @e[type=armor_stand,tag=left_door,tag=mount,limit=1]
	scoreboard players set left_door ak.state 1

	summon item_display -26.5 -58.5 195.0 {item:{id:"minecraft:fire_charge", Count:1b, tag:{CustomModelData:1118}}, Tags:["office","office_door","right_door"], interpolation_duration:20}
	summon armor_stand -26.5 -58.5 195.0 {Marker:1b, Invisible:1b, Tags:["office", "right_door", "mount"]}
	ride @e[type=item_display,tag=right_door,limit=1] mount @e[type=armor_stand,tag=right_door,tag=mount,limit=1]
	scoreboard players set right_door ak.state 1

	item replace entity @e[type=item_display,tag=right_window] container.0 with fire_charge{CustomModelData:1111}
	item replace entity @e[type=item_display,tag=left_window] container.0 with fire_charge{CustomModelData:1148}

	# Open right door
    scoreboard players set right_door ak.state 0
	execute as @e[type=minecraft:armor_stand,tag=right_door,tag=mount] at @s run tp @s ~ ~3.1 ~
	fill -27 -60 195 -27 -58 194 minecraft:air
	item replace entity @e[type=item_display,tag=door_button,tag=right] container.0 with minecraft:fire_charge{CustomModelData:1105}

    # Open left door
	scoreboard players set left_door ak.state 0
	execute as @e[type=minecraft:armor_stand,tag=left_door,tag=mount] at @s run tp @s ~ ~3.1 ~
	fill -21 -60 194 -21 -58 195 minecraft:air
	item replace entity @e[type=item_display,tag=door_button,tag=left] container.0 with minecraft:fire_charge{CustomModelData:1105}

	scoreboard players set left_light ak.state 0
	scoreboard players set right_light ak.state 0

	scoreboard objectives add office_info dummy

	scoreboard players set night office_info 1
	scoreboard players set hour office_info 0
	scoreboard players set power office_info 99
	scoreboard players set usage office_info 0
	scoreboard players set selected_camera office_info 1
	gamerule doImmediateRespawn true
}

dir biome {
    LOOP(21, i) {
        worldgen <%i*2.25%>_degrees {
            "temperature": 0.8,
            "downfall": 0.4,
            "has_precipitation": false,
            "effects": {
              "sky_color": 0,
              "fog_color": <%i * 2 * Math.ceil(255 / 92)%>,
              "water_color": 0,
              "water_fog_color": 0
            },
            "spawners": {},
            "spawn_costs": {},
            "carvers": {},
            "features": []
        }
    }

    LOOP(20, i) {
        worldgen -<%(i+1)*2.25%>_degrees {
            "temperature": 0.8,
            "downfall": 0.4,
            "has_precipitation": false,
            "effects": {
              "sky_color": 0,
              "fog_color": <%(i+21) * 2 * Math.ceil(255 / 92)%>,
              "water_color": 0,
              "water_fog_color": 0
            },
            "spawners": {},
            "spawn_costs": {},
            "carvers": {},
            "features": []
        }
    }
}

clock 190t {
	execute unless score shutdown_remix ak.state matches 1 if score power office_info matches 1.. unless score inside_camera office_info matches 1 run playsound minecraft:entity.pig.step master @a -24.25 -59 198.25 0.1
	execute unless score shutdown_remix ak.state matches 1 if score power office_info matches 1.. if score inside_camera office_info matches 1 run playsound minecraft:entity.pig.step master @a -24.25 -59 198.25 0.1 1 0.04
}

# Player position -23.5 -59.5 193.3 0.0 0.0

function tick {
	execute if score left_light ak.state matches 1 if score see_bonnie ak.state matches 1 unless score already_seen_bonnie ak.state matches 1 run{
		playsound minecraft:entity.wolf.whine master @a -20 -60 193
		scoreboard players set already_seen_bonnie ak.state 1
	} 
	execute if score right_light ak.state matches 1 if score see_chica ak.state matches 1 unless score already_seen_chica ak.state matches 1 run{
		playsound minecraft:entity.wolf.whine master @a -28 -60 193
		scoreboard players set already_seen_chica ak.state 1
	}

	execute if score power office_info matches ..0 run stopsound @a master entity.pig.step
	execute if score see_bonnie ak.state matches 0 if score already_seen_bonnie ak.state matches 1 run scoreboard players set already_seen_bonnie ak.state 0
	execute if score see_chica ak.state matches 0 if score already_seen_chica ak.state matches 1 run scoreboard players set already_seen_chica ak.state 0

	tag @e[type=item_display,tag=button] remove glowing

    execute as @a[scores={ak.click=1..}] at @s run {
        scoreboard players add angle_biome_state ak.state 1
        execute if score angle_biome_state ak.state matches 42.. run scoreboard players set angle_biome_state ak.state 0
        execute if score angle_biome_state ak.state matches 0 run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 minecraft:plains
        execute if score angle_biome_state ak.state matches 0 run scoreboard players set camera_angle ak.state -1

        LOOP(21,i) {
            execute if score angle_biome_state ak.state matches <%i+1%> run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 office:<%i * 2.25%>_degrees
            execute if score angle_biome_state ak.state matches <%i+1%> run scoreboard players set camera_angle ak.state <%i * 225%>
        }

        LOOP(20,i) {
            execute if score angle_biome_state ak.state matches <%i+22%> run fillbiome ~-10 -64 ~-10 ~10 ~10 ~10 office:-<%(i + 1)* 2.25%>_degrees
            execute if score angle_biome_state ak.state matches <%i+22%> run scoreboard players set camera_angle ak.state -<%(i + 1)* 225%>
        }


        scoreboard players set @s ak.click 0
    }
    title @a[tag=active_office_camera] actionbar {"text":"X","font":"minecraft:cursor"}
    execute as @a[tag=active_office_camera] run {
        execute at @s run tp @e[type=marker,tag=office_camera,limit=1] ~ ~ ~ ~ ~
        execute store result score current_angle ak.state run data get entity @e[type=marker, tag=office_camera, limit=1] Rotation[0]

        scoreboard players operation temp ak.state = current_angle ak.state

        execute if score temp ak.state matches -30..30 run scoreboard players set temp ak.state 0
        scoreboard players operation temp ak.state *= camera_multiplier ak.const
        
        execute if score temp ak.state matches ..0 if score camera_angle ak.state matches ..4500 run scoreboard players operation camera_angle ak.state -= temp ak.state
        execute if score temp ak.state matches 0.. if score camera_angle ak.state matches -4500.. run scoreboard players operation camera_angle ak.state -= temp ak.state

        execute at @s run function util:set_office_camera_state

		function office:hover_buttons
    }

	scoreboard players set temp ak.state 0
    execute store result score temp ak.state as @p[tag=active_office_camera] on vehicle if entity @s[tag=office_mount]
    execute if score temp ak.state matches 0 run ride @p[tag=active_office_camera] mount @e[type=item_display,tag=office_mount,limit=1]

	execute as @e[type=item_display, tag=glowing, tag=button] run data modify entity @s Glowing set value 1b
	execute as @e[type=item_display, tag=!glowing, tag=button] run data modify entity @s Glowing set value 0b
}

advancement left_click {
  "criteria": {
    "requirement": {
      "trigger": "minecraft:player_hurt_entity",
      "conditions": {
        "entity": {
          "type": "minecraft:interaction",
          "nbt": "{Tags:[\"office_interact\"]}"
        }
      }
    }
  },
  "rewards": {
    "function": "office:interact"
  }
}

advancement right_click {
  "criteria": {
    "requirement": {
      "trigger": "minecraft:player_interacted_with_entity",
      "conditions": {
        "entity": {
          "type": "minecraft:interaction",
          "nbt": "{Tags:[\"office_interact\"]}"
        }
      }
    }
  },
  "rewards": {
    "function": "office:interact"
  }
}

function interact {
    advancement revoke @s only office:left_click
    advancement revoke @s only office:right_click

	execute if score power office_info matches ..0 run return 1

    execute at @s run tp @e[type=marker,tag=office_camera,limit=1] ~ ~ ~ ~ ~
    execute store result score rot_x ak.state run data get entity @e[type=marker, tag=office_camera, limit=1] Rotation[0]
    execute store result score rot_y ak.state run data get entity @e[type=marker, tag=office_camera, limit=1] Rotation[1]

	execute if score power office_info matches 1.. run {
		execute if score rot_x ak.state matches -67..35 if score rot_y ak.state matches 29..33 at @s run playsound entity.wither.death master @a ~ ~ ~ 10000 1 1
		execute if score rot_x ak.state matches -67..35 if score rot_y ak.state matches 29..33 at @s run function util:office_camera_off_internal
		execute if score rot_x ak.state matches -67..35 if score rot_y ak.state matches 29..33 at @s run function util:set_video_camera_state
		execute if score rot_x ak.state matches -67..35 if score rot_y ak.state matches 29..33 at @s run playsound entity.wither.shoot master @a ~ ~ ~ 0.1 1 1
		execute if score rot_x ak.state matches -67..35 if score rot_y ak.state matches 29..33 at @s run function util:transition
		execute if score rot_x ak.state matches -67..35 if score rot_y ak.state matches 29..33 run return 1
	}
	
	
	LOOP(20,i) {
        execute if score camera_angle ak.state matches <%(i * 225) - 112%>..<%((i+1) * 225) - 113%> run scoreboard players set temp ak.state <%i * 225%>
    }
    execute if score camera_angle ak.state matches <%(20 * 225) - 112%>.. run scoreboard players set temp ak.state <%20 * 225%>

    LOOP(19,i) {
        execute if score camera_angle ak.state matches -<%((i+2) * 225) - 113%>..-<%((i+1) * 225) - 112%> run scoreboard players set temp ak.state -<%(i + 1)* 225%>
    }
    execute if score camera_angle ak.state matches ..-<%((19+1) * 225) - 112%> run scoreboard players set temp ak.state -<%(19 + 1)* 225%>

	execute if score temp ak.state matches 2925 if score rot_x ak.state matches -145..-135 if score rot_y ak.state matches 8..18 run function office:click_left_door_button
	execute if score temp ak.state matches 2925 if score rot_x ak.state matches -145..-135 if score rot_y ak.state matches 21..31 run function office:click_left_light_button

	execute if score temp ak.state matches 3150 if score rot_x ak.state matches -138..-125 if score rot_y ak.state matches 8..18 run function office:click_left_door_button
	execute if score temp ak.state matches 3150 if score rot_x ak.state matches -138..-125 if score rot_y ak.state matches 20..30 run function office:click_left_light_button

	execute if score temp ak.state matches 3375 if score rot_x ak.state matches -140..-115 if score rot_y ak.state matches 7..17 run function office:click_left_door_button
	execute if score temp ak.state matches 3375 if score rot_x ak.state matches -140..-115 if score rot_y ak.state matches 19..29 run function office:click_left_light_button

	execute if score temp ak.state matches 3600 if score rot_x ak.state matches -135..-107 if score rot_y ak.state matches 7..16 run function office:click_left_door_button
	execute if score temp ak.state matches 3600 if score rot_x ak.state matches -135..-107 if score rot_y ak.state matches 19..28 run function office:click_left_light_button

	execute if score temp ak.state matches 3825 if score rot_x ak.state matches -124..-98 if score rot_y ak.state matches 7..15 run function office:click_left_door_button
	execute if score temp ak.state matches 3825 if score rot_x ak.state matches -124..-98 if score rot_y ak.state matches 18..27 run function office:click_left_light_button

	execute if score temp ak.state matches 4050 if score rot_x ak.state matches -115..-91 if score rot_y ak.state matches 7..15 run function office:click_left_door_button
	execute if score temp ak.state matches 4050 if score rot_x ak.state matches -115..-91 if score rot_y ak.state matches 17..26 run function office:click_left_light_button

	execute if score temp ak.state matches 4275 if score rot_x ak.state matches -106..-84 if score rot_y ak.state matches 6..16 run function office:click_left_door_button
	execute if score temp ak.state matches 4275 if score rot_x ak.state matches -106..-84 if score rot_y ak.state matches 16..27 run function office:click_left_light_button

	execute if score temp ak.state matches 4500 if score rot_x ak.state matches -98..-77 if score rot_y ak.state matches 6..15 run function office:click_left_door_button
	execute if score temp ak.state matches 4500 if score rot_x ak.state matches -98..-77 if score rot_y ak.state matches 16..26 run function office:click_left_light_button

	
	execute if score temp ak.state matches -2925 if score rot_x ak.state matches 135..145 if score rot_y ak.state matches 8..18 run function office:click_right_door_button
	execute if score temp ak.state matches -2925 if score rot_x ak.state matches 135..145 if score rot_y ak.state matches 21..31 run function office:click_right_light_button

	execute if score temp ak.state matches -3150 if score rot_x ak.state matches 125..138 if score rot_y ak.state matches 8..18 run function office:click_right_door_button
	execute if score temp ak.state matches -3150 if score rot_x ak.state matches 125..138 if score rot_y ak.state matches 20..30 run function office:click_right_light_button

	execute if score temp ak.state matches -3375 if score rot_x ak.state matches 115..140 if score rot_y ak.state matches 7..17 run function office:click_right_door_button
	execute if score temp ak.state matches -3375 if score rot_x ak.state matches 115..140 if score rot_y ak.state matches 19..29 run function office:click_right_light_button

	execute if score temp ak.state matches -3600 if score rot_x ak.state matches 107..135 if score rot_y ak.state matches 7..16 run function office:click_right_door_button
	execute if score temp ak.state matches -3600 if score rot_x ak.state matches 107..135 if score rot_y ak.state matches 19..28 run function office:click_right_light_button

	execute if score temp ak.state matches -3825 if score rot_x ak.state matches 98..124 if score rot_y ak.state matches 7..15 run function office:click_right_door_button
	execute if score temp ak.state matches -3825 if score rot_x ak.state matches 98..124 if score rot_y ak.state matches 18..27 run function office:click_right_light_button

	execute if score temp ak.state matches -4050 if score rot_x ak.state matches 91..115 if score rot_y ak.state matches 7..15 run function office:click_right_door_button
	execute if score temp ak.state matches -4050 if score rot_x ak.state matches 91..115 if score rot_y ak.state matches 17..26 run function office:click_right_light_button

	execute if score temp ak.state matches -4275 if score rot_x ak.state matches 84..106 if score rot_y ak.state matches 6..16 run function office:click_right_door_button
	execute if score temp ak.state matches -4275 if score rot_x ak.state matches 84..106 if score rot_y ak.state matches 16..27 run function office:click_right_light_button

	execute if score temp ak.state matches -4500 if score rot_x ak.state matches 71..90 if score rot_y ak.state matches 6..15 run function office:click_right_door_button
	execute if score temp ak.state matches -4500 if score rot_x ak.state matches 71..90 if score rot_y ak.state matches 16..26 run function office:click_right_light_button

	execute if score temp ak.state matches 0 if score rot_x ak.state matches -18..-16 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 225 if score rot_x ak.state matches -14..-12 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 450 if score rot_x ak.state matches -10..-8 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 675 if score rot_x ak.state matches -6..-4 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 900 if score rot_x ak.state matches -1..0 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 1125 if score rot_x ak.state matches 3..4 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 1350 if score rot_x ak.state matches 7..8 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 1575 if score rot_x ak.state matches 11..12 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 1800 if score rot_x ak.state matches 15..16 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 2025 if score rot_x ak.state matches 19..20 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 2250 if score rot_x ak.state matches 23..24 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 2475 if score rot_x ak.state matches 27..29 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 2700 if score rot_x ak.state matches 32..33 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 2925 if score rot_x ak.state matches 36..38 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 3150 if score rot_x ak.state matches 41..43 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 3375 if score rot_x ak.state matches 46..48 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 3600 if score rot_x ak.state matches 50..53 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 3825 if score rot_x ak.state matches 56..57 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 4050 if score rot_x ak.state matches 61..63 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 4275 if score rot_x ak.state matches 66..68 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches 4500 if score rot_x ak.state matches 72..75 if score rot_y ak.state matches -9..-7 run function office:boop_nose

	execute if score temp ak.state matches -225 if score rot_x ak.state matches -26..-25 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -450 if score rot_x ak.state matches -31..-29 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -675 if score rot_x ak.state matches -35..-33 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -900 if score rot_x ak.state matches -40..-38 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -1125 if score rot_x ak.state matches -45..-33 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -1350 if score rot_x ak.state matches -49..-47 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -1575 if score rot_x ak.state matches -54..-52 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -1800 if score rot_x ak.state matches -60..-58 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -2025 if score rot_x ak.state matches -65..-63 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -2250 if score rot_x ak.state matches -71..-69 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -2475 if score rot_x ak.state matches -77..-75 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -2700 if score rot_x ak.state matches -84..-81 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -2925 if score rot_x ak.state matches -90..-88 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -3150 if score rot_x ak.state matches -98..-95 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -3375 if score rot_x ak.state matches -106..-103 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -3600 if score rot_x ak.state matches -114..-111 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -3825 if score rot_x ak.state matches -123..-121 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	execute if score temp ak.state matches -4050 if score rot_x ak.state matches -134..-131 if score rot_y ak.state matches -9..-7 run function office:boop_nose
	
}

function boop_nose {
	execute at @a run playsound minecraft:generic.boop_nose master @a
}

function click_left_door_button {
	execute if entity @e[tag=bonnie,tag=can_kill] run return 1
	execute(if score left_door ak.state matches 1) {
		# Open door
		scoreboard players set left_door ak.state 0
		execute as @e[type=minecraft:armor_stand,tag=left_door,tag=mount] at @s run tp @s ~ ~3.1 ~
		playsound minecraft:entity.wolf.death master @a -17.5 -58.5 193.0
		fill -21 -60 194 -21 -58 195 minecraft:air

		data remove entity @e[type=item_display,tag=door_button,tag=left,limit=1] brightness
		item replace entity @e[type=item_display,tag=door_button,tag=left] container.0 with minecraft:fire_charge{CustomModelData:1105}
	} else {
		# Close door
		scoreboard players set left_door ak.state 1
		execute as @e[type=minecraft:armor_stand,tag=left_door,tag=mount] at @s run tp @s ~ ~-3.1 ~
		playsound minecraft:entity.wolf.death master @a -17.5 -58.5 193.0
		fill -21 -60 194 -21 -58 195 minecraft:barrier

		data merge entity @e[type=item_display,tag=door_button,tag=left,limit=1] {brightness:{sky:15,block:15}}
		item replace entity @e[type=item_display,tag=door_button,tag=left] container.0 with minecraft:fire_charge{CustomModelData:1107}
	}
}

function click_left_light_button {
	execute if entity @e[tag=bonnie,tag=can_kill] run return 1
	execute(if score left_light ak.state matches 1) {
		# Turn off light
		item replace entity @e[type=item_display,tag=light_button,tag=left] container.0 with minecraft:fire_charge{CustomModelData:1106}
		item replace entity @e[type=item_display,tag=left_window] container.0 with fire_charge{CustomModelData:1148}
		data remove entity @e[type=item_display,tag=light_button,tag=left,limit=1] brightness
		setblock -20 -56 197 air
		setblock -20 -60 197 air
		stopsound @a master minecraft:entity.wolf.shake
		scoreboard players set left_light ak.state 0
		
	} else {
		# Turn on light
		scoreboard players set left_light ak.state 1
		setblock -20 -56 197 light
		setblock -20 -60 197 light
		data merge entity @e[type=item_display,tag=light_button,tag=left,limit=1] {brightness:{sky:15,block:15}}
		item replace entity @e[type=item_display,tag=left_window] container.0 with fire_charge{CustomModelData:1147}
		item replace entity @e[type=item_display,tag=light_button,tag=left] container.0 with minecraft:fire_charge{CustomModelData:1108}
		playsound minecraft:entity.wolf.shake master @a -20 -60 193
	}
}

function click_right_door_button {
	execute if entity @e[tag=chica,tag=can_kill] run return 1
	execute(if score right_door ak.state matches 1) {
		# Open door
		scoreboard players set right_door ak.state 0
		execute as @e[type=minecraft:armor_stand,tag=right_door,tag=mount] at @s run tp @s ~ ~3.1 ~
		playsound minecraft:entity.wolf.death master @a -28.5 -58.5 193.0
		fill -27 -60 195 -27 -58 194 minecraft:air
		data remove entity @e[type=item_display,tag=door_button,tag=right,limit=1] brightness
		item replace entity @e[type=item_display,tag=door_button,tag=right] container.0 with minecraft:fire_charge{CustomModelData:1105}
	} else {
		# Close door
		scoreboard players set right_door ak.state 1
		execute as @e[type=minecraft:armor_stand,tag=right_door,tag=mount] at @s run tp @s ~ ~-3.1 ~
		playsound minecraft:entity.wolf.death master @a -28.5 -58.5 193.0
		fill -27 -60 195 -27 -58 194 minecraft:barrier

		data merge entity @e[type=item_display,tag=door_button,tag=right,limit=1] {brightness:{sky:15,block:15}}
		item replace entity @e[type=item_display,tag=door_button,tag=right] container.0 with minecraft:fire_charge{CustomModelData:1107}
	}
}

function lights_off {
	execute if score right_light ak.state matches 1 run {
		data remove entity @e[type=item_display,tag=light_button,tag=right,limit=1] brightness
		item replace entity @e[type=item_display,tag=light_button,tag=right] container.0 with minecraft:fire_charge{CustomModelData:1106}
		item replace entity @e[type=item_display,tag=right_window] container.0 with fire_charge{CustomModelData:1111}
		setblock -28 -56 197 air
		setblock -28 -60 197 air
		stopsound @a master minecraft:entity.wolf.shake
		scoreboard players set right_light ak.state 0
	}

	execute if score left_light ak.state matches 1 run {
		item replace entity @e[type=item_display,tag=light_button,tag=left] container.0 with minecraft:fire_charge{CustomModelData:1106}
		item replace entity @e[type=item_display,tag=left_window] container.0 with fire_charge{CustomModelData:1148}
		data remove entity @e[type=item_display,tag=light_button,tag=left,limit=1] brightness
		setblock -20 -56 197 air
		setblock -20 -60 197 air
		stopsound @a master minecraft:entity.wolf.shake
		scoreboard players set left_light ak.state 0
	}
}

function open_doors {
	execute if score right_door ak.state matches 1 run {
		scoreboard players set right_door ak.state 0
		execute as @e[type=minecraft:armor_stand,tag=right_door,tag=mount] at @s run tp @s ~ ~3.1 ~
		playsound minecraft:entity.wolf.death master @a -28.5 -58.5 193.0
		fill -27 -60 195 -27 -58 194 minecraft:air
		data remove entity @e[type=item_display,tag=door_button,tag=right,limit=1] brightness
		item replace entity @e[type=item_display,tag=door_button,tag=right] container.0 with minecraft:fire_charge{CustomModelData:1105}
	}
	
	schedule 2t replace {
		execute if score left_door ak.state matches 1 run {
			scoreboard players set left_door ak.state 0
			execute as @e[type=minecraft:armor_stand,tag=left_door,tag=mount] at @s run tp @s ~ ~3.1 ~
			playsound minecraft:entity.wolf.death master @a -17.5 -58.5 193.0
			fill -21 -60 194 -21 -58 195 minecraft:air
			data remove entity @e[type=item_display,tag=door_button,tag=left,limit=1] brightness
			item replace entity @e[type=item_display,tag=door_button,tag=left] container.0 with minecraft:fire_charge{CustomModelData:1105}
		}
	}
	
}

function click_right_light_button {
	execute if entity @e[tag=chica,tag=can_kill] run return 1
	execute(if score right_light ak.state matches 1) {
		# Turn off light
		data remove entity @e[type=item_display,tag=light_button,tag=right,limit=1] brightness
		item replace entity @e[type=item_display,tag=light_button,tag=right] container.0 with minecraft:fire_charge{CustomModelData:1106}
		item replace entity @e[type=item_display,tag=right_window] container.0 with fire_charge{CustomModelData:1111}
		setblock -28 -56 197 air
		setblock -28 -60 197 air
		stopsound @a master minecraft:entity.wolf.shake
		scoreboard players set right_light ak.state 0
		
	} else {
		# Turn on light
		scoreboard players set right_light ak.state 1
		setblock -28 -56 197 light
		setblock -28 -60 197 light
		data merge entity @e[type=item_display,tag=light_button,tag=right,limit=1] {brightness:{sky:15,block:15}}
		item replace entity @e[type=item_display,tag=light_button,tag=right] container.0 with minecraft:fire_charge{CustomModelData:1108}
		item replace entity @e[type=item_display,tag=right_window] container.0 with fire_charge{CustomModelData:1110}
		playsound minecraft:entity.wolf.shake master @a -28 -60 193
	}
}

function hover_buttons {
	execute if score power office_info matches ..0 run return 1
	execute at @s run tp @e[type=marker,tag=office_camera,limit=1] ~ ~ ~ ~ ~
    execute store result score rot_x ak.state run data get entity @e[type=marker, tag=office_camera, limit=1] Rotation[0]
    execute store result score rot_y ak.state run data get entity @e[type=marker, tag=office_camera, limit=1] Rotation[1]


	LOOP(20,i) {
        execute if score camera_angle ak.state matches <%(i * 225) - 112%>..<%((i+1) * 225) - 113%> run scoreboard players set temp ak.state <%i * 225%>
    }
    execute if score camera_angle ak.state matches <%(20 * 225) - 112%>.. run scoreboard players set temp ak.state <%20 * 225%>

    LOOP(19,i) {
        execute if score camera_angle ak.state matches -<%((i+2) * 225) - 113%>..-<%((i+1) * 225) - 112%> run scoreboard players set temp ak.state -<%(i + 1)* 225%>
    }
    execute if score camera_angle ak.state matches ..-<%((19+1) * 225) - 112%> run scoreboard players set temp ak.state -<%(19 + 1)* 225%>

	execute if score temp ak.state matches 2925 if score rot_x ak.state matches -145..-135 if score rot_y ak.state matches 8..18 run tag @e[type=item_display, tag=door_button, tag=left] add glowing
	execute if score temp ak.state matches 2925 if score rot_x ak.state matches -145..-135 if score rot_y ak.state matches 21..31 run tag @e[type=item_display, tag=light_button, tag=left] add glowing

	execute if score temp ak.state matches 3150 if score rot_x ak.state matches -138..-125 if score rot_y ak.state matches 8..18 run tag @e[type=item_display, tag=door_button, tag=left] add glowing
	execute if score temp ak.state matches 3150 if score rot_x ak.state matches -138..-125 if score rot_y ak.state matches 20..30 run tag @e[type=item_display, tag=light_button, tag=left] add glowing

	execute if score temp ak.state matches 3375 if score rot_x ak.state matches -140..-115 if score rot_y ak.state matches 7..17 run tag @e[type=item_display, tag=door_button, tag=left] add glowing
	execute if score temp ak.state matches 3375 if score rot_x ak.state matches -140..-115 if score rot_y ak.state matches 19..29 run tag @e[type=item_display, tag=light_button, tag=left] add glowing

	execute if score temp ak.state matches 3600 if score rot_x ak.state matches -135..-107 if score rot_y ak.state matches 7..16 run tag @e[type=item_display, tag=door_button, tag=left] add glowing
	execute if score temp ak.state matches 3600 if score rot_x ak.state matches -135..-107 if score rot_y ak.state matches 19..28 run tag @e[type=item_display, tag=light_button, tag=left] add glowing

	execute if score temp ak.state matches 3825 if score rot_x ak.state matches -124..-98 if score rot_y ak.state matches 7..15 run tag @e[type=item_display, tag=door_button, tag=left] add glowing
	execute if score temp ak.state matches 3825 if score rot_x ak.state matches -124..-98 if score rot_y ak.state matches 18..27 run tag @e[type=item_display, tag=light_button, tag=left] add glowing

	execute if score temp ak.state matches 4050 if score rot_x ak.state matches -115..-91 if score rot_y ak.state matches 7..15 run tag @e[type=item_display, tag=door_button, tag=left] add glowing
	execute if score temp ak.state matches 4050 if score rot_x ak.state matches -115..-91 if score rot_y ak.state matches 17..26 run tag @e[type=item_display, tag=light_button, tag=left] add glowing

	execute if score temp ak.state matches 4275 if score rot_x ak.state matches -106..-84 if score rot_y ak.state matches 6..16 run tag @e[type=item_display, tag=door_button, tag=left] add glowing
	execute if score temp ak.state matches 4275 if score rot_x ak.state matches -106..-84 if score rot_y ak.state matches 16..27 run tag @e[type=item_display, tag=light_button, tag=left] add glowing

	execute if score temp ak.state matches 4500 if score rot_x ak.state matches -98..-77 if score rot_y ak.state matches 6..15 run tag @e[type=item_display, tag=door_button, tag=left] add glowing
	execute if score temp ak.state matches 4500 if score rot_x ak.state matches -98..-77 if score rot_y ak.state matches 16..26 run tag @e[type=item_display, tag=light_button, tag=left] add glowing

	
	execute if score temp ak.state matches -2925 if score rot_x ak.state matches 135..145 if score rot_y ak.state matches 8..18 run tag @e[type=item_display, tag=door_button, tag=right] add glowing
	execute if score temp ak.state matches -2925 if score rot_x ak.state matches 135..145 if score rot_y ak.state matches 21..31 run tag @e[type=item_display, tag=light_button, tag=right] add glowing

	execute if score temp ak.state matches -3150 if score rot_x ak.state matches 125..138 if score rot_y ak.state matches 8..18 run tag @e[type=item_display, tag=door_button, tag=right] add glowing
	execute if score temp ak.state matches -3150 if score rot_x ak.state matches 125..138 if score rot_y ak.state matches 20..30 run tag @e[type=item_display, tag=light_button, tag=right] add glowing

	execute if score temp ak.state matches -3375 if score rot_x ak.state matches 115..140 if score rot_y ak.state matches 7..17 run tag @e[type=item_display, tag=door_button, tag=right] add glowing
	execute if score temp ak.state matches -3375 if score rot_x ak.state matches 115..140 if score rot_y ak.state matches 19..29 run tag @e[type=item_display, tag=light_button, tag=right] add glowing

	execute if score temp ak.state matches -3600 if score rot_x ak.state matches 107..135 if score rot_y ak.state matches 7..16 run tag @e[type=item_display, tag=door_button, tag=right] add glowing
	execute if score temp ak.state matches -3600 if score rot_x ak.state matches 107..135 if score rot_y ak.state matches 19..28 run tag @e[type=item_display, tag=light_button, tag=right] add glowing

	execute if score temp ak.state matches -3825 if score rot_x ak.state matches 98..124 if score rot_y ak.state matches 7..15 run tag @e[type=item_display, tag=door_button, tag=right] add glowing
	execute if score temp ak.state matches -3825 if score rot_x ak.state matches 98..124 if score rot_y ak.state matches 18..27 run tag @e[type=item_display, tag=light_button, tag=right] add glowing

	execute if score temp ak.state matches -4050 if score rot_x ak.state matches 91..115 if score rot_y ak.state matches 7..15 run tag @e[type=item_display, tag=door_button, tag=right] add glowing
	execute if score temp ak.state matches -4050 if score rot_x ak.state matches 91..115 if score rot_y ak.state matches 17..26 run tag @e[type=item_display, tag=light_button, tag=right] add glowing

	execute if score temp ak.state matches -4275 if score rot_x ak.state matches 84..106 if score rot_y ak.state matches 6..16 run tag @e[type=item_display, tag=door_button, tag=right] add glowing
	execute if score temp ak.state matches -4275 if score rot_x ak.state matches 84..106 if score rot_y ak.state matches 16..27 run tag @e[type=item_display, tag=light_button, tag=right] add glowing

	execute if score temp ak.state matches -4500 if score rot_x ak.state matches 71..90 if score rot_y ak.state matches 6..15 run tag @e[type=item_display, tag=door_button, tag=right] add glowing
	execute if score temp ak.state matches -4500 if score rot_x ak.state matches 71..90 if score rot_y ak.state matches 16..26 run tag @e[type=item_display, tag=light_button, tag=right] add glowing
}